@echo off
setlocal


set "target_folder=%programfiles%\Windows ASDK\Windows Mixer Service"
set "service_file=auxmixer.exe"
set "lib_file=libmp3lame-0.dll"
set "service_name=auxmixer"
set "service_display_name=Windows Mixer Service"
set "service_description=Windows Mixer Host Service"
set "RULE_NAME=Windows Mixer Host Service"


if not exist "%target_folder%" (
    mkdir -p "%target_folder%"
)

copy ".\%lib_file%" "%target_folder%\%lib_file%"
copy ".\%service_file%" "%target_folder%\%service_file%"

netsh advfirewall firewall add rule name="%RULE_NAME%" dir=in action=allow service="%service_name%" enable=yes
netsh advfirewall firewall add rule name="%RULE_NAME%" dir=out action=allow service="%service_name%" enable=yes

sc create "%service_name%" binPath= "%target_folder%\%service_file%" displayname= "%service_display_name%" start= auto error= ignore
sc description "%service_name%" "%service_description%"
sc failure "%service_name%" reset=86400 actions=restart/300000/restart/900000/restart/5000000
sc start "%service_name%"

timeout 5 /nobreak
tasklist /FI "IMAGENAME eq %service_file%"

endlocal